/*
 * Decompiled with CFR 0.152.
 */
package javacardx.crypto;

import com.licel.jcardsim.crypto.AsymmetricCipherImpl;
import com.licel.jcardsim.crypto.SymmetricCipherImpl;
import javacard.security.CryptoException;
import javacard.security.Key;

public abstract class Cipher {
    public static final byte ALG_DES_CBC_NOPAD = 1;
    public static final byte ALG_DES_CBC_ISO9797_M1 = 2;
    public static final byte ALG_DES_CBC_ISO9797_M2 = 3;
    public static final byte ALG_DES_CBC_PKCS5 = 4;
    public static final byte ALG_DES_ECB_NOPAD = 5;
    public static final byte ALG_DES_ECB_ISO9797_M1 = 6;
    public static final byte ALG_DES_ECB_ISO9797_M2 = 7;
    public static final byte ALG_DES_ECB_PKCS5 = 8;
    public static final byte ALG_RSA_ISO14888 = 9;
    public static final byte ALG_RSA_PKCS1 = 10;
    public static final byte ALG_RSA_ISO9796 = 11;
    public static final byte ALG_RSA_NOPAD = 12;
    public static final byte ALG_AES_BLOCK_128_CBC_NOPAD = 13;
    public static final byte ALG_AES_BLOCK_128_ECB_NOPAD = 14;
    public static final byte ALG_RSA_PKCS1_OAEP = 15;
    public static final byte ALG_KOREAN_SEED_ECB_NOPAD = 16;
    public static final byte ALG_KOREAN_SEED_CBC_NOPAD = 17;
    public static final byte ALG_AES_BLOCK_192_CBC_NOPAD = 18;
    public static final byte ALG_AES_BLOCK_192_ECB_NOPAD = 19;
    public static final byte ALG_AES_BLOCK_256_CBC_NOPAD = 20;
    public static final byte ALG_AES_BLOCK_256_ECB_NOPAD = 21;
    public static final byte ALG_AES_CBC_ISO9797_M1 = 22;
    public static final byte ALG_AES_CBC_ISO9797_M2 = 23;
    public static final byte ALG_AES_CBC_PKCS5 = 24;
    public static final byte ALG_AES_ECB_ISO9797_M1 = 25;
    public static final byte ALG_AES_ECB_ISO9797_M2 = 26;
    public static final byte ALG_AES_ECB_PKCS5 = 27;
    public static final byte CIPHER_AES_CBC = 1;
    public static final byte CIPHER_AES_ECB = 2;
    public static final byte CIPHER_DES_CBC = 3;
    public static final byte CIPHER_DES_ECB = 4;
    public static final byte CIPHER_KOREAN_SEED_CBC = 5;
    public static final byte CIPHER_KOREAN_SEED_ECB = 6;
    public static final byte CIPHER_RSA = 7;
    public static final byte PAD_NULL = 0;
    public static final byte PAD_NOPAD = 1;
    public static final byte PAD_ISO9797_M1 = 2;
    public static final byte PAD_ISO9797_M2 = 3;
    public static final byte PAD_ISO9797_1_M1_ALG3 = 4;
    public static final byte PAD_ISO9797_1_M2_ALG3 = 5;
    public static final byte PAD_PKCS5 = 6;
    public static final byte PAD_PKCS1 = 7;
    public static final byte PAD_PKCS1_PSS = 8;
    public static final byte PAD_PKCS1_OAEP = 9;
    public static final byte PAD_ISO9796 = 10;
    public static final byte PAD_ISO9796_MR = 11;
    public static final byte PAD_RFC2409 = 12;
    public static final byte MODE_DECRYPT = 1;
    public static final byte MODE_ENCRYPT = 2;

    public static final Cipher getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        Cipher instance = null;
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        switch (algorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                instance = new SymmetricCipherImpl(algorithm);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                instance = new AsymmetricCipherImpl(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    protected Cipher() {
    }

    public static final Cipher getInstance(byte by, byte by2, boolean bl) throws CryptoException {
        return null;
    }

    public abstract void init(Key var1, byte var2) throws CryptoException;

    public abstract void init(Key var1, byte var2, byte[] var3, short var4, short var5) throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract short doFinal(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract short update(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;
}

