/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.smartcardio;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.base.SimulatorRuntime;
import com.licel.jcardsim.io.JavaxSmartCardInterface;
import com.licel.jcardsim.smartcardio.CardTerminalSimulator;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class CardSimulator
extends JavaxSmartCardInterface {
    private final CardImpl card = new CardImpl();
    private final AtomicReference<CardTerminal> owningCardTerminalReference = new AtomicReference();
    private final AtomicReference<Thread> threadReference = new AtomicReference();

    public CardSimulator() {
        this(new SimulatorRuntime());
    }

    public CardSimulator(SimulatorRuntime runtime) {
        super(runtime);
    }

    public ResponseAPDU transmitCommand(CommandAPDU commandApdu) {
        return new ResponseAPDU(this.transmitCommand(commandApdu.getBytes()));
    }

    public synchronized void assignToTerminal(CardTerminal terminal) {
        CardTerminal oldCardTerminal = this.owningCardTerminalReference.getAndSet(terminal);
        if (terminal == oldCardTerminal) {
            return;
        }
        if (oldCardTerminal != null) {
            ((CardTerminalSimulator.CardTerminalImpl)oldCardTerminal).assignSimulator(null);
        }
        if (terminal != null) {
            this.card.disconnect();
            ((CardTerminalSimulator.CardTerminalImpl)terminal).assignSimulator(this);
        }
    }

    public CardTerminal getAssignedCardTerminal() {
        return this.owningCardTerminalReference.get();
    }

    final Card internalConnect(String protocol) {
        this.card.connect(protocol);
        return this.card;
    }

    final void internalEject(CardTerminal oldTerminal) {
        if (this.owningCardTerminalReference.compareAndSet(oldTerminal, null)) {
            this.card.eject();
        }
    }

    private final class CardImpl
    extends Card {
        private final CardChannel basicChannel;
        private volatile String protocol = "T=0";
        private volatile byte protocolByte = 0;
        private volatile CardState state = CardState.Connected;

        CardImpl() {
            this.basicChannel = new CardChannelImpl(this, 0);
        }

        void ensureConnected() {
            CardState cardState = this.state;
            if (cardState == CardState.Disconnected) {
                throw new IllegalStateException("Card was disconnected");
            }
            if (cardState == CardState.Ejected) {
                throw new IllegalStateException("Card was removed");
            }
        }

        public ATR getATR() {
            return new ATR(CardSimulator.this.getATR());
        }

        public String getProtocol() {
            return this.protocol;
        }

        public CardChannel getBasicChannel() {
            return this.basicChannel;
        }

        public CardChannel openLogicalChannel() throws CardException {
            throw new CardException("Logical channel not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginExclusive() throws CardException {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                if (!CardSimulator.this.threadReference.compareAndSet(null, Thread.currentThread())) {
                    throw new CardException("Card is held exclusively by Thread " + CardSimulator.this.threadReference.get());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endExclusive() throws CardException {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                if (!CardSimulator.this.threadReference.compareAndSet(Thread.currentThread(), null)) {
                    throw new CardException("Card is held exclusively by Thread " + CardSimulator.this.threadReference.get());
                }
            }
        }

        public byte[] transmitControlCommand(int i, byte[] bytes) throws CardException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect(boolean reset) throws CardException {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                if (reset) {
                    CardSimulator.this.reset();
                }
                this.state = CardState.Disconnected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connect(String protocol) {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                this.protocolByte = CardSimulator.this.getProtocolByte(protocol);
                this.protocol = protocol;
                this.state = CardState.Connected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void eject() {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                CardSimulator.this.reset();
                this.state = CardState.Ejected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnect() {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                CardSimulator.this.reset();
                this.state = CardState.Disconnected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] transmitCommand(byte[] capdu) throws CardException {
            SimulatorRuntime simulatorRuntime = CardSimulator.this.runtime;
            synchronized (simulatorRuntime) {
                byte[] byArray;
                this.ensureConnected();
                Thread thread = (Thread)CardSimulator.this.threadReference.get();
                if (thread != null && thread != Thread.currentThread()) {
                    throw new CardException("Card is held exclusively by Thread " + thread.getName());
                }
                byte currentProtocol = CardSimulator.this.getProtocolByte(CardSimulator.this.getProtocol());
                try {
                    CardSimulator.this.runtime.changeProtocol(this.protocolByte);
                    byArray = CardManager.dispatchApdu(CardSimulator.this, capdu);
                    CardSimulator.this.runtime.changeProtocol(currentProtocol);
                }
                catch (Throwable throwable) {
                    CardSimulator.this.runtime.changeProtocol(currentProtocol);
                    throw throwable;
                }
                return byArray;
            }
        }
    }

    private static final class CardChannelImpl
    extends CardChannel {
        private final CardImpl card;
        private final int channelNr;

        public CardChannelImpl(CardImpl card, int channelNr) {
            this.card = card;
            this.channelNr = channelNr;
        }

        public Card getCard() {
            return this.card;
        }

        public int getChannelNumber() {
            this.card.ensureConnected();
            return this.channelNr;
        }

        public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
            return new ResponseAPDU(this.card.transmitCommand(commandAPDU.getBytes()));
        }

        public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CardException {
            byte[] result = this.card.transmitCommand(new CommandAPDU(byteBuffer).getBytes());
            byteBuffer2.put(result);
            return result.length;
        }

        public void close() throws CardException {
            throw new CardException("Can not close basic channel");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CardState {
        Connected,
        Disconnected,
        Ejected;

    }
}

