/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.samples;

import com.licel.jcardsim.samples.BaseApplet;
import javacard.framework.APDU;
import javacard.framework.AppletEvent;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;

public class MultiInstanceApplet
extends BaseApplet
implements AppletEvent {
    private static final byte CLA = -128;
    private static final byte INS_GET_FULL_AID = 0;
    private static final byte INS_GET_COUNT = 2;
    private static final byte INS_MAKE_UNUSABLE = 4;
    private static final byte CLA_MASK = -16;
    private static short instanceCounter = 0;
    private boolean locked = false;

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new MultiInstanceApplet().register();
    }

    protected MultiInstanceApplet() {
        instanceCounter = (short)(instanceCounter + 1);
    }

    public boolean select() {
        return !this.locked;
    }

    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        short readCount = apdu.setIncomingAndReceive();
        short lc = apdu.getIncomingLength();
        short offsetCData = apdu.getOffsetCdata();
        short read = readCount;
        while (read < lc) {
            read = (short)(read + apdu.receiveBytes(read));
        }
        if (this.selectingApplet()) {
            byte dataSize = buffer[4];
            buffer[1] = 111;
            buffer[2] = (byte)(dataSize + 2);
            buffer[3] = -124;
            buffer[4] = dataSize;
            apdu.setOutgoingAndSend((short)1, (short)(dataSize + 4));
            return;
        }
        if ((buffer[0] & 0xFFFFFFF0) != -128) {
            ISOException.throwIt((short)28160);
        }
        switch (buffer[1]) {
            case 0: {
                short dataSize = JCSystem.getAID().getBytes(buffer, (short)0);
                apdu.setOutgoingAndSend((short)0, dataSize);
                break;
            }
            case 2: {
                Util.setShort(buffer, (short)0, instanceCounter);
                apdu.setOutgoingAndSend((short)0, (short)2);
            }
            case 4: {
                this.locked = true;
                break;
            }
            default: {
                ISOException.throwIt((short)27904);
            }
        }
    }

    public void uninstall() {
        instanceCounter = (short)(instanceCounter - 1);
    }
}

