/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.samples;

import com.licel.jcardsim.samples.BaseApplet;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.Util;

public class DualInterfaceApplet
extends BaseApplet {
    private static final byte CLA = -128;
    private static final byte INS_READ = 0;
    private static final byte INS_WRITE = 2;
    private static final byte INS_INFO = 4;
    private static final byte CLA_MASK = -16;
    private static final byte _0 = 0;
    private static final byte _1 = 1;
    private final byte[] store = new byte[255];
    private short storeLen = 0;

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new DualInterfaceApplet().register();
    }

    protected DualInterfaceApplet() {
    }

    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        short readCount = apdu.setIncomingAndReceive();
        short lc = apdu.getIncomingLength();
        short offsetCData = apdu.getOffsetCdata();
        short read = readCount;
        while (read < lc) {
            read = (short)(read + apdu.receiveBytes(read));
        }
        if (this.selectingApplet()) {
            return;
        }
        if ((buffer[0] & 0xFFFFFFF0) != -128) {
            ISOException.throwIt((short)28160);
        }
        switch (buffer[1]) {
            case 0: {
                Util.arrayCopyNonAtomic(this.store, (short)0, buffer, (short)0, this.storeLen);
                apdu.setOutgoingAndSend((short)0, this.storeLen);
                break;
            }
            case 2: {
                if (this.isContacted()) {
                    this.storeLen = lc;
                    Util.arrayCopyNonAtomic(buffer, offsetCData, this.store, (short)0, this.storeLen);
                    break;
                }
                ISOException.throwIt((short)27013);
                break;
            }
            case 4: {
                buffer[0] = APDU.getProtocol();
                apdu.setOutgoingAndSend((short)0, (short)1);
                break;
            }
            default: {
                ISOException.throwIt((short)27904);
            }
        }
    }

    public boolean isContacted() {
        return APDU.getProtocol() == 0 || APDU.getProtocol() == 1;
    }
}

