/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.base.SimulatorRuntime;
import com.licel.jcardsim.remote.JavaCardRemoteInterface;
import com.licel.jcardsim.remote.SerializableAID;
import java.io.FileInputStream;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Properties;

public class JavaCardRemoteServer
extends UnicastRemoteObject
implements JavaCardRemoteInterface {
    protected final Simulator sim = new Simulator(new SimulatorRuntime());

    public JavaCardRemoteServer(String host, int port) throws RemoteException {
        System.setProperty("java.rmi.server.hostname", host);
        Registry registry = LocateRegistry.createRegistry(port);
        registry.rebind("jCardSim.rmiServer", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String serverPort;
        if (args.length != 1) {
            System.out.println("Usage: java com.licel.jcardsim.remote.JavaCardRemoteServer <jcardsim.cfg>");
            System.exit(-1);
        }
        Properties cfg = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(args[0]);
            cfg.load(fis);
        }
        catch (Throwable t) {
            System.err.println("Unable to load configuration " + args[0] + " due to: " + t.getMessage());
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        Enumeration<?> keys = cfg.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            System.setProperty(propertyName, cfg.getProperty(propertyName));
        }
        String serverHost = System.getProperty("com.licel.jcardsim.terminal.host");
        if (serverHost == null) {
            System.err.println("Invalid configuration: missing 'com.licel.jcardsim.terminal.host' property");
            System.exit(-1);
        }
        if ((serverPort = System.getProperty("com.licel.jcardsim.terminal.port")) == null) {
            System.err.println("Invalid configuration: missing 'com.licel.jcardsim.terminal.port' property");
            System.exit(-1);
        }
        new JavaCardRemoteServer(serverHost, Integer.parseInt(serverPort));
    }

    public SerializableAID loadApplet(SerializableAID aid, String appletClassName) throws RemoteException {
        return new SerializableAID(this.sim.loadApplet(aid.getAID(), appletClassName));
    }

    public SerializableAID loadApplet(SerializableAID aid, String appletClassName, byte[] appletJarContents) throws RemoteException {
        return new SerializableAID(this.sim.loadApplet(aid.getAID(), appletClassName, appletJarContents));
    }

    public SerializableAID createApplet(SerializableAID aid, byte[] bArray, short bOffset, byte bLength) throws RemoteException {
        return new SerializableAID(this.sim.createApplet(aid.getAID(), bArray, bOffset, bLength));
    }

    public byte[] transmitCommand(byte[] data) throws RemoteException {
        return this.sim.transmitCommand(data);
    }

    public boolean selectApplet(SerializableAID aid) throws RemoteException {
        return this.sim.selectApplet(aid.getAID());
    }

    public void reset() throws RemoteException {
        this.sim.reset();
    }

    public byte[] getATR() throws RemoteException {
        return this.sim.getATR();
    }

    public void changeProtocol(String protocol) throws RemoteException {
        this.sim.changeProtocol(protocol);
    }

    public String getProtocol() throws RemoteException {
        return this.sim.getProtocol();
    }

    public byte[] selectAppletWithResult(SerializableAID aid) throws RemoteException {
        return this.sim.selectAppletWithResult(aid.getAID());
    }
}

