/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.remote.BixVReaderIPCProtocol;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class BixVReaderCard {
    Simulator sim = new Simulator();

    public BixVReaderCard(int idx) throws IOException {
        BixVReaderIPCProtocol driverProtocol = new BixVReaderIPCProtocol();
        driverProtocol.connect(idx);
        IOThread ioThread = new IOThread(this.sim, driverProtocol);
        ShutDownHook hook = new ShutDownHook(ioThread);
        Runtime.getRuntime().addShutdownHook(hook);
        ioThread.start();
        driverProtocol.writeEventCommand(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java com.licel.jcardsim.remote.BixVReaderCard <jcardsim.cfg>");
            System.exit(-1);
        }
        Properties cfg = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(args[0]);
            cfg.load(fis);
        }
        catch (Throwable t) {
            System.err.println("Unable to load configuration " + args[0] + " due to: " + t.getMessage());
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        Enumeration<?> keys = cfg.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            System.setProperty(propertyName, cfg.getProperty(propertyName));
        }
        int readerIdx = Integer.parseInt(System.getProperty("com.licel.jcardsim.bixvreader.idx", "0"));
        BixVReaderCard server = new BixVReaderCard(readerIdx);
    }

    static class IOThread
    extends Thread {
        BixVReaderIPCProtocol driverProtocol;
        Simulator sim;
        boolean isRunning;

        public IOThread(Simulator sim, BixVReaderIPCProtocol driverProtocol) {
            this.sim = sim;
            this.driverProtocol = driverProtocol;
            this.isRunning = true;
        }

        public void run() {
            while (this.isRunning) {
                try {
                    int cmd = this.driverProtocol.readCommand();
                    switch (cmd) {
                        case 0: 
                        case 1: {
                            this.driverProtocol.writeData(this.sim.getATR());
                            break;
                        }
                        case 2: {
                            byte[] apdu = this.driverProtocol.readData();
                            this.driverProtocol.writeData(CardManager.dispatchApdu(this.sim, apdu));
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    static class ShutDownHook
    extends Thread {
        IOThread ioThread;

        public ShutDownHook(IOThread ioThread) {
            this.ioThread = ioThread;
        }

        public void run() {
            this.ioThread.isRunning = false;
            System.out.println("Shutdown connections");
            try {
                this.ioThread.driverProtocol.writeEventCommand(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ioThread.driverProtocol.disconnect();
        }
    }
}

