/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.framework.service;

import javacard.framework.APDU;
import javacard.framework.Util;
import javacard.framework.service.BasicService;
import javacard.framework.service.ServiceException;

public class BasicServiceImpl
extends BasicService {
    public boolean processDataIn(APDU apdu) {
        return false;
    }

    public boolean processCommand(APDU apdu) {
        return false;
    }

    public boolean processDataOut(APDU apdu) {
        return false;
    }

    public short receiveInData(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() != 0 && apdu.getCurrentState() != 2) {
            ServiceException.throwIt((short)4);
        }
        if (apdu.getCurrentState() == 2) {
            return 0;
        }
        short bytesRead = apdu.setIncomingAndReceive();
        if (apdu.getCurrentState() != 2) {
            ServiceException.throwIt((short)3);
        }
        return bytesRead;
    }

    public void setProcessed(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() < 0) {
            ServiceException.throwIt((short)5);
        }
        if (apdu.getCurrentState() < 3) {
            apdu.setOutgoing();
        }
    }

    public boolean isProcessed(APDU apdu) {
        return apdu.getCurrentState() < 0 || apdu.getCurrentState() >= 3;
    }

    public void setOutputLength(APDU apdu, short length) throws ServiceException {
        if (length < 0 || length > 256) {
            ServiceException.throwIt((short)1);
        }
        apdu.getBuffer()[4] = (byte)length;
    }

    public short getOutputLength(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() < 3) {
            ServiceException.throwIt((short)5);
        }
        return (short)(apdu.getBuffer()[4] & 0xFFFFFFFF);
    }

    public void setStatusWord(APDU apdu, short sw) {
        Util.setShort(apdu.getBuffer(), (short)2, sw);
    }

    public short getStatusWord(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() < 3) {
            ServiceException.throwIt((short)5);
        }
        return Util.getShort(apdu.getBuffer(), (short)2);
    }

    public boolean fail(APDU apdu, short sw) throws ServiceException {
        if (apdu.getCurrentState() < 0) {
            ServiceException.throwIt((short)5);
        }
        this.setProcessed(apdu);
        this.setOutputLength(apdu, (short)0);
        this.setStatusWord(apdu, sw);
        return true;
    }

    public boolean succeed(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() < 0) {
            ServiceException.throwIt((short)5);
        }
        this.setProcessed(apdu);
        this.setStatusWord(apdu, (short)-28672);
        return true;
    }

    public boolean succeedWithStatusWord(APDU apdu, short sw) throws ServiceException {
        if (apdu.getCurrentState() < 0) {
            ServiceException.throwIt((short)5);
        }
        this.setProcessed(apdu);
        this.setStatusWord(apdu, sw);
        return true;
    }

    public byte getCLA(APDU apdu) {
        return apdu.getBuffer()[0];
    }

    public byte getINS(APDU apdu) {
        return apdu.getBuffer()[1];
    }

    public byte getP1(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() != 0 && apdu.getCurrentState() != 2) {
            ServiceException.throwIt((short)4);
        }
        return apdu.getBuffer()[2];
    }

    public byte getP2(APDU apdu) throws ServiceException {
        if (apdu.getCurrentState() != 0 && apdu.getCurrentState() != 2) {
            ServiceException.throwIt((short)4);
        }
        return apdu.getBuffer()[3];
    }

    public boolean selectingApplet() {
        try {
            return this.getINS(APDU.getCurrentAPDU()) == -92;
        }
        catch (SecurityException se) {
            return false;
        }
    }
}

