/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.BasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA1Digest;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.licel.jcardsim.crypto.ECPrivateKeyImpl;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.KeyAgreement;
import javacard.security.PrivateKey;

public class KeyAgreementImpl
extends KeyAgreement {
    BasicAgreement engine;
    SHA1Digest digestEngine;
    byte algorithm;
    ECPrivateKeyImpl privateKey;

    public KeyAgreementImpl(byte algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case 1: {
                this.engine = new ECDHBasicAgreement();
                break;
            }
            case 2: {
                this.engine = new ECDHCBasicAgreement();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.digestEngine = new SHA1Digest();
    }

    public void init(PrivateKey privateKey) throws CryptoException {
        if (privateKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!(privateKey instanceof ECPrivateKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        this.engine.init(((ECPrivateKeyImpl)privateKey).getParameters());
        this.privateKey = (ECPrivateKeyImpl)privateKey;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public short generateSecret(byte[] publicData, short publicOffset, short publicLength, byte[] secret, short secretOffset) throws CryptoException {
        byte[] publicKey = new byte[publicLength];
        Util.arrayCopyNonAtomic(publicData, publicOffset, publicKey, (short)0, publicLength);
        ECPublicKeyParameters ecp = new ECPublicKeyParameters(((ECPrivateKeyParameters)this.privateKey.getParameters()).getParameters().getCurve().decodePoint(publicKey), ((ECPrivateKeyParameters)this.privateKey.getParameters()).getParameters());
        byte[] result = this.engine.calculateAgreement(ecp).toByteArray();
        byte[] hashResult = new byte[20];
        this.digestEngine.update(result, 0, result.length);
        this.digestEngine.doFinal(hashResult, 0);
        Util.arrayCopyNonAtomic(hashResult, (short)0, secret, secretOffset, (short)hashResult.length);
        return (short)hashResult.length;
    }
}

