/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.ECKeyImpl;
import javacard.security.CryptoException;
import javacard.security.ECPrivateKey;

public class ECPrivateKeyImpl
extends ECKeyImpl
implements ECPrivateKey {
    protected ByteContainer s = new ByteContainer();

    public ECPrivateKeyImpl(byte keyType, short keySize) {
        super(keyType, keySize);
    }

    public ECPrivateKeyImpl(ECPrivateKeyParameters params) {
        super(params);
        this.setParameters(params);
    }

    public void setParameters(CipherParameters params) {
        this.s.setBigInteger(((ECPrivateKeyParameters)params).getD());
    }

    public void setS(byte[] buffer, short offset, short length) throws CryptoException {
        this.s.setBytes(buffer, offset, length);
    }

    public short getS(byte[] buffer, short offset) throws CryptoException {
        return this.s.getBytes(buffer, offset);
    }

    public boolean isInitialized() {
        return this.isDomainParametersInitialized() && this.s.isInitialized();
    }

    public void clearKey() {
        super.clearKey();
        this.s.clear();
    }

    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new ECPrivateKeyParameters(this.s.getBigInteger(), this.getDomainParameters());
    }
}

