/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DSAKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.DSAKeyImpl;
import javacard.security.CryptoException;
import javacard.security.DSAPublicKey;

public class DSAPublicKeyImpl
extends DSAKeyImpl
implements DSAPublicKey {
    protected ByteContainer y = new ByteContainer();

    public DSAPublicKeyImpl(short keySize) {
        super((byte)7, keySize);
    }

    public DSAPublicKeyImpl(DSAPublicKeyParameters params) {
        super(params);
        this.setParameters(params);
    }

    public void setParameters(CipherParameters params) {
        this.y.setBigInteger(((DSAPublicKeyParameters)params).getY());
    }

    public void setY(byte[] buffer, short offset, short length) throws CryptoException {
        this.y.setBytes(buffer, offset, length);
    }

    public short getY(byte[] buffer, short offset) {
        return this.y.getBytes(buffer, offset);
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.y.isInitialized();
    }

    public void clearKey() {
        super.clearKey();
        this.y.clear();
    }

    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new DSAPublicKeyParameters(this.y.getBigInteger(), ((DSAKeyParameters)super.getParameters()).getParameters());
    }
}

