/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.asn1.x509;

import com.licel.jcardsim.bouncycastle.asn1.ASN1Encodable;
import com.licel.jcardsim.bouncycastle.asn1.ASN1EncodableVector;
import com.licel.jcardsim.bouncycastle.asn1.ASN1OctetString;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Sequence;
import com.licel.jcardsim.bouncycastle.asn1.ASN1TaggedObject;
import com.licel.jcardsim.bouncycastle.asn1.DERObject;
import com.licel.jcardsim.bouncycastle.asn1.DEROctetString;
import com.licel.jcardsim.bouncycastle.asn1.DERSequence;
import com.licel.jcardsim.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class DigestInfo
extends ASN1Encodable {
    private byte[] digest;
    private AlgorithmIdentifier algId;

    public static DigestInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DigestInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DigestInfo getInstance(Object object) {
        if (object instanceof DigestInfo) {
            return (DigestInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DigestInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public DigestInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.digest = byArray;
        this.algId = algorithmIdentifier;
    }

    public DigestInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.algId = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.digest = ASN1OctetString.getInstance(enumeration.nextElement()).getOctets();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.algId);
        aSN1EncodableVector.add(new DEROctetString(this.digest));
        return new DERSequence(aSN1EncodableVector);
    }
}

