/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.asn1;

import com.licel.jcardsim.bouncycastle.asn1.ASN1EncodableVector;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Object;
import com.licel.jcardsim.bouncycastle.asn1.DERInteger;
import com.licel.jcardsim.bouncycastle.asn1.DERObject;
import com.licel.jcardsim.bouncycastle.asn1.DERObjectIdentifier;
import com.licel.jcardsim.bouncycastle.asn1.DEROutputStream;
import com.licel.jcardsim.bouncycastle.asn1.DERTaggedObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERExternal
extends ASN1Object {
    private DERObjectIdentifier directReference;
    private DERInteger indirectReference;
    private ASN1Object dataValueDescriptor;
    private int encoding;
    private DERObject externalContent;

    public DERExternal(ASN1EncodableVector aSN1EncodableVector) {
        int n = 0;
        DERObject dERObject = this.getObjFromVector(aSN1EncodableVector, n);
        if (dERObject instanceof DERObjectIdentifier) {
            this.directReference = (DERObjectIdentifier)dERObject;
            dERObject = this.getObjFromVector(aSN1EncodableVector, ++n);
        }
        if (dERObject instanceof DERInteger) {
            this.indirectReference = (DERInteger)dERObject;
            dERObject = this.getObjFromVector(aSN1EncodableVector, ++n);
        }
        if (!(dERObject instanceof DERTaggedObject)) {
            this.dataValueDescriptor = (ASN1Object)dERObject;
            dERObject = this.getObjFromVector(aSN1EncodableVector, ++n);
        }
        if (aSN1EncodableVector.size() != n + 1) {
            throw new IllegalArgumentException("input vector too large");
        }
        if (!(dERObject instanceof DERTaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
        this.setEncoding(dERTaggedObject.getTagNo());
        this.externalContent = dERTaggedObject.getObject();
    }

    private DERObject getObjFromVector(ASN1EncodableVector aSN1EncodableVector, int n) {
        if (aSN1EncodableVector.size() <= n) {
            throw new IllegalArgumentException("too few objects in input vector");
        }
        return aSN1EncodableVector.get(n).getDERObject();
    }

    public DERExternal(DERObjectIdentifier dERObjectIdentifier, DERInteger dERInteger, ASN1Object aSN1Object, DERTaggedObject dERTaggedObject) {
        this(dERObjectIdentifier, dERInteger, aSN1Object, dERTaggedObject.getTagNo(), dERTaggedObject.getDERObject());
    }

    public DERExternal(DERObjectIdentifier dERObjectIdentifier, DERInteger dERInteger, ASN1Object aSN1Object, int n, DERObject dERObject) {
        this.setDirectReference(dERObjectIdentifier);
        this.setIndirectReference(dERInteger);
        this.setDataValueDescriptor(aSN1Object);
        this.setEncoding(n);
        this.setExternalContent(dERObject.getDERObject());
    }

    public int hashCode() {
        int n = 0;
        if (this.directReference != null) {
            n = this.directReference.hashCode();
        }
        if (this.indirectReference != null) {
            n ^= this.indirectReference.hashCode();
        }
        if (this.dataValueDescriptor != null) {
            n ^= this.dataValueDescriptor.hashCode();
        }
        return n ^= this.externalContent.hashCode();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.directReference != null) {
            byteArrayOutputStream.write(this.directReference.getDEREncoded());
        }
        if (this.indirectReference != null) {
            byteArrayOutputStream.write(this.indirectReference.getDEREncoded());
        }
        if (this.dataValueDescriptor != null) {
            byteArrayOutputStream.write(this.dataValueDescriptor.getDEREncoded());
        }
        DERTaggedObject dERTaggedObject = new DERTaggedObject(this.encoding, this.externalContent);
        byteArrayOutputStream.write(dERTaggedObject.getDEREncoded());
        dEROutputStream.writeEncoded(32, 8, byteArrayOutputStream.toByteArray());
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERExternal)) {
            return false;
        }
        if (this == dERObject) {
            return true;
        }
        DERExternal dERExternal = (DERExternal)dERObject;
        if (!(this.directReference == null || dERExternal.directReference != null && dERExternal.directReference.equals(this.directReference))) {
            return false;
        }
        if (!(this.indirectReference == null || dERExternal.indirectReference != null && dERExternal.indirectReference.equals(this.indirectReference))) {
            return false;
        }
        if (!(this.dataValueDescriptor == null || dERExternal.dataValueDescriptor != null && dERExternal.dataValueDescriptor.equals(this.dataValueDescriptor))) {
            return false;
        }
        return this.externalContent.equals(dERExternal.externalContent);
    }

    public ASN1Object getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public DERObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public DERObject getExternalContent() {
        return this.externalContent;
    }

    public DERInteger getIndirectReference() {
        return this.indirectReference;
    }

    private void setDataValueDescriptor(ASN1Object aSN1Object) {
        this.dataValueDescriptor = aSN1Object;
    }

    private void setDirectReference(DERObjectIdentifier dERObjectIdentifier) {
        this.directReference = dERObjectIdentifier;
    }

    private void setEncoding(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + n);
        }
        this.encoding = n;
    }

    private void setExternalContent(DERObject dERObject) {
        this.externalContent = dERObject;
    }

    private void setIndirectReference(DERInteger dERInteger) {
        this.indirectReference = dERInteger;
    }
}

