/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.ApduCase;
import com.licel.jcardsim.base.LoadFile;
import com.licel.jcardsim.base.Module;
import com.licel.jcardsim.base.SimulatorSystem;
import com.licel.jcardsim.base.TransientMemory;
import com.licel.jcardsim.utils.AIDUtil;
import com.licel.jcardsim.utils.BiConsumer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.AppletEvent;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.Util;
import javacardx.apdu.ExtendedLength;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulatorRuntime {
    protected final ThreadLocal<BiConsumer<Applet, AID>> registrationCallback;
    protected final SortedMap<AID, ApplicationInstance> applets = new TreeMap<AID, ApplicationInstance>(AIDUtil.comparator());
    protected final SortedMap<AID, LoadFile> loadFiles = new TreeMap<AID, LoadFile>(AIDUtil.comparator());
    protected final SortedMap<AID, AID> generatedLoadFileAIDs = new TreeMap<AID, AID>(AIDUtil.comparator());
    protected final Method apduPrivateResetMethod;
    protected final byte[] responseBuffer = new byte[32769];
    protected final TransientMemory transientMemory;
    protected final APDU shortAPDU;
    protected final APDU extendedAPDU;
    protected AID currentAID;
    protected AID previousAID;
    protected short responseBufferSize = 0;
    protected boolean selecting = false;
    protected boolean usingExtendedAPDUs = false;
    protected byte currentProtocol = 0;
    protected byte transactionDepth = 0;
    protected Object previousActiveObject;

    public SimulatorRuntime() {
        this(new TransientMemory());
    }

    public SimulatorRuntime(TransientMemory transientMemory) {
        this.transientMemory = transientMemory;
        try {
            Constructor<?> ctor = APDU.class.getDeclaredConstructors()[0];
            ctor.setAccessible(true);
            this.shortAPDU = (APDU)ctor.newInstance(false);
            this.extendedAPDU = (APDU)ctor.newInstance(true);
            this.apduPrivateResetMethod = APDU.class.getDeclaredMethod("internalReset", Byte.TYPE, ApduCase.class, byte[].class);
            this.apduPrivateResetMethod.setAccessible(true);
            Field f = Applet.class.getDeclaredField("registrationCallback");
            f.setAccessible(true);
            this.registrationCallback = (ThreadLocal)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal reflection error", (Throwable)e);
        }
    }

    protected final void activateSimulatorRuntimeInstance() {
        SimulatorSystem.setCurrentInstance(this);
    }

    public AID getAID() {
        return this.currentAID;
    }

    public AID lookupAID(byte[] buffer, short offset, byte length) {
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(buffer, offset, length)) continue;
            return aid;
        }
        return null;
    }

    public ApplicationInstance lookupApplet(AID lookupAid) {
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(lookupAid)) continue;
            return (ApplicationInstance)this.applets.get(aid);
        }
        return null;
    }

    public AID getPreviousContextAID() {
        return this.previousAID;
    }

    protected Applet getApplet(AID aid) {
        if (aid == null) {
            return null;
        }
        ApplicationInstance a = this.lookupApplet(aid);
        if (a == null) {
            return null;
        }
        return a.getApplet();
    }

    public void loadApplet(AID aid, Class<? extends Applet> appletClass) {
        if (this.generatedLoadFileAIDs.keySet().contains(aid)) {
            throw new SystemException(4);
        }
        byte[] generated = new byte[]{-1, -1, -1, 0, 0};
        Util.setShort(generated, (short)3, (short)this.generatedLoadFileAIDs.size());
        AID generatedAID = AIDUtil.create(generated);
        this.generatedLoadFileAIDs.put(aid, generatedAID);
        this.loadLoadFile(new LoadFile(generatedAID, generatedAID, appletClass));
    }

    public void loadLoadFile(LoadFile loadFile) {
        AID key = loadFile.getAid();
        if (this.loadFiles.keySet().contains(key) || this.applets.keySet().contains(key)) {
            throw new IllegalStateException("LoadFile AID already used");
        }
        this.loadFiles.put(key, loadFile);
    }

    protected void deleteApplet(AID aid) {
        this.activateSimulatorRuntimeInstance();
        ApplicationInstance applicationInstance = this.lookupApplet(aid);
        if (applicationInstance == null) {
            throw new SystemException(4);
        }
        this.applets.remove(aid);
        Applet applet = applicationInstance.getApplet();
        if (applet == null) {
            return;
        }
        if (this.getApplet(this.currentAID) == applet) {
            this.deselect(applicationInstance);
        }
        if (applet instanceof AppletEvent) {
            try {
                ((AppletEvent)((Object)applet)).uninstall();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isAppletSelecting(Object aThis) {
        return aThis == this.getApplet(this.getAID()) && this.selecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transmitCommand(byte[] command) throws SystemException {
        byte[] theSW;
        block20: {
            this.activateSimulatorRuntimeInstance();
            ApduCase apduCase = ApduCase.getCase(command);
            theSW = new byte[2];
            Applet applet = this.getApplet(this.getAID());
            this.selecting = false;
            if (!apduCase.isExtended() && SimulatorRuntime.isAppletSelectionApdu(command)) {
                AID newAid = this.findAppletForSelectApdu(command, apduCase);
                if (newAid != null) {
                    this.deselect(this.lookupApplet(this.getAID()));
                    this.currentAID = newAid;
                    applet = this.getApplet(this.getAID());
                    this.selecting = true;
                } else if (applet == null) {
                    Util.setShort(theSW, (short)0, (short)27033);
                    return theSW;
                }
            }
            if (applet == null) {
                Util.setShort(theSW, (short)0, (short)27014);
                return theSW;
            }
            if (apduCase.isExtended()) {
                if (!(applet instanceof ExtendedLength)) {
                    Util.setShort(theSW, (short)0, (short)26368);
                    return theSW;
                }
                this.usingExtendedAPDUs = true;
            } else {
                this.usingExtendedAPDUs = false;
            }
            this.responseBufferSize = 0;
            APDU apdu = this.getCurrentAPDU();
            try {
                if (this.selecting) {
                    boolean success;
                    try {
                        success = applet.select();
                    }
                    catch (Exception e) {
                        success = false;
                    }
                    if (!success) {
                        throw new ISOException(27033);
                    }
                }
                this.resetAPDU(apdu, apduCase, command);
                applet.process(apdu);
                Util.setShort(theSW, (short)0, (short)-28672);
            }
            catch (Throwable e) {
                Util.setShort(theSW, (short)0, (short)28416);
                if (e instanceof CardException) {
                    Util.setShort(theSW, (short)0, ((CardException)e).getReason());
                    break block20;
                }
                if (e instanceof CardRuntimeException) {
                    Util.setShort(theSW, (short)0, ((CardRuntimeException)e).getReason());
                }
            }
            finally {
                this.selecting = false;
                this.resetAPDU(apdu, null, null);
            }
        }
        if (theSW[0] != 97) {
            if (theSW[0] < -112) return theSW;
            if (theSW[0] > -97) return theSW;
        }
        byte[] response = new byte[this.responseBufferSize + 2];
        Util.arrayCopyNonAtomic(this.responseBuffer, (short)0, response, (short)0, this.responseBufferSize);
        Util.arrayCopyNonAtomic(theSW, (short)0, response, this.responseBufferSize, (short)2);
        return response;
    }

    protected AID findAppletForSelectApdu(byte[] selectApdu, ApduCase apduCase) {
        if (apduCase == ApduCase.Case1 || apduCase == ApduCase.Case2) {
            return this.applets.isEmpty() ? null : this.applets.firstKey();
        }
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(selectApdu, (short)5, selectApdu[4])) continue;
            return aid;
        }
        for (AID aid : this.applets.keySet()) {
            if (!aid.partialEquals(selectApdu, (short)5, selectApdu[4])) continue;
            return aid;
        }
        return null;
    }

    protected void deselect(ApplicationInstance applicationInstance) {
        this.activateSimulatorRuntimeInstance();
        if (applicationInstance != null) {
            try {
                Applet applet = applicationInstance.getApplet();
                applet.deselect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getTransactionDepth() != 0) {
            this.abortTransaction();
        }
        this.transientMemory.clearOnDeselect();
    }

    public void sendAPDU(byte[] buffer, short bOff, short len) {
        this.responseBufferSize = Util.arrayCopyNonAtomic(buffer, bOff, this.responseBuffer, this.responseBufferSize, len);
    }

    public void reset() {
        Arrays.fill(this.responseBuffer, (byte)0);
        this.transactionDepth = 0;
        this.responseBufferSize = 0;
        this.currentAID = null;
        this.previousAID = null;
        this.transientMemory.clearOnReset();
    }

    public void resetRuntime() {
        this.activateSimulatorRuntimeInstance();
        Iterator<AID> aids = this.applets.keySet().iterator();
        ArrayList<AID> aidsToTrash = new ArrayList<AID>();
        while (aids.hasNext()) {
            AID aid = aids.next();
            aidsToTrash.add(aid);
        }
        for (AID anAidsToTrash : aidsToTrash) {
            this.deleteApplet(anAidsToTrash);
        }
        this.loadFiles.clear();
        this.generatedLoadFileAIDs.clear();
        Arrays.fill(this.responseBuffer, (byte)0);
        this.transactionDepth = 0;
        this.responseBufferSize = 0;
        this.currentAID = null;
        this.previousAID = null;
        this.transientMemory.clearOnReset();
        this.transientMemory.forgetBuffers();
    }

    public TransientMemory getTransientMemory() {
        return this.transientMemory;
    }

    protected void resetAPDU(APDU apdu, ApduCase apduCase, byte[] buffer) {
        try {
            this.apduPrivateResetMethod.invoke((Object)apdu, new Object[]{this.currentProtocol, apduCase, buffer});
        }
        catch (Exception e) {
            throw new RuntimeException("Internal reflection error", (Throwable)e);
        }
    }

    public APDU getCurrentAPDU() {
        return this.usingExtendedAPDUs ? this.extendedAPDU : this.shortAPDU;
    }

    public void changeProtocol(byte protocol) {
        this.currentProtocol = protocol;
        this.resetAPDU(this.shortAPDU, null, null);
        this.resetAPDU(this.extendedAPDU, null, null);
    }

    public byte getAssignedChannel() {
        return 0;
    }

    public void beginTransaction() {
        if (this.transactionDepth != 0) {
            TransactionException.throwIt((short)1);
        }
        this.transactionDepth = 1;
    }

    public void abortTransaction() {
        if (this.transactionDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        this.transactionDepth = 0;
    }

    public void commitTransaction() {
        if (this.transactionDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        this.transactionDepth = 0;
    }

    public byte getTransactionDepth() {
        return this.transactionDepth;
    }

    public short getUnusedCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public short getMaxCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public short getAvailablePersistentMemory() {
        return Short.MAX_VALUE;
    }

    public short getAvailableTransientResetMemory() {
        return Short.MAX_VALUE;
    }

    public short getAvailableTransientDeselectMemory() {
        return Short.MAX_VALUE;
    }

    public Shareable getSharedObject(AID serverAID, byte parameter) {
        Applet serverApplet = this.getApplet(serverAID);
        if (serverApplet != null) {
            return serverApplet.getShareableInterfaceObject(this.getAID(), parameter);
        }
        return null;
    }

    public boolean isObjectDeletionSupported() {
        return false;
    }

    public void requestObjectDeletion() {
        if (!this.isObjectDeletionSupported()) {
            throw new SystemException(6);
        }
    }

    public void setJavaOwner(Object obj, Object owner) {
    }

    public Object getJavaOwner(Object obj) {
        return obj;
    }

    public short getJavaContext(Object obj) {
        return 0;
    }

    public Object getPreviousActiveObject() {
        return this.previousActiveObject;
    }

    public void setPreviousActiveObject(Object previousActiveObject) {
        this.previousActiveObject = previousActiveObject;
    }

    protected static boolean isAppletSelectionApdu(byte[] apdu) {
        int channelMask = -4;
        int p2Mask = -29;
        byte cla = (byte)(apdu[0] & 0xFFFFFFFC);
        byte ins = apdu[1];
        byte p1 = apdu[2];
        byte p2 = (byte)(apdu[3] & 0xFFFFFFE3);
        return cla == 0 && ins == -92 && p1 == 4 && p2 == 0;
    }

    public void installApplet(AID appletAid, byte[] bArray, short bOffset, byte bLength) {
        AID generatedAID = (AID)this.generatedLoadFileAIDs.get(appletAid);
        if (generatedAID == null || !this.loadFiles.keySet().contains(generatedAID)) {
            throw new SystemException(4);
        }
        this.installApplet(generatedAID, generatedAID, appletAid, bArray, bOffset, bLength);
    }

    public void installApplet(AID loadFileAID, AID moduleAID, final AID appletAID, byte[] bArray, short bOffset, byte bLength) {
        Method initMethod;
        this.activateSimulatorRuntimeInstance();
        LoadFile loadFile = (LoadFile)this.loadFiles.get(loadFileAID);
        if (loadFile == null) {
            throw new IllegalArgumentException("LoadFile AID not found " + AIDUtil.toString(loadFileAID));
        }
        Module module = loadFile.getModule(moduleAID);
        if (module == null) {
            throw new IllegalArgumentException("Module AID not found " + AIDUtil.toString(moduleAID));
        }
        Class<? extends Applet> appletClass = module.getAppletClass();
        try {
            initMethod = appletClass.getMethod("install", byte[].class, Short.TYPE, Byte.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class does not provide install method");
        }
        final AtomicInteger callCount = new AtomicInteger(0);
        this.registrationCallback.set(new BiConsumer<Applet, AID>(){

            @Override
            public void accept(Applet applet, AID installAID) {
                if (callCount.incrementAndGet() != 1) {
                    throw new SystemException(4);
                }
                if (installAID != null) {
                    SimulatorRuntime.this.applets.put(installAID, new ApplicationInstance(installAID, applet));
                } else {
                    SimulatorRuntime.this.applets.put(appletAID, new ApplicationInstance(appletAID, applet));
                }
            }
        });
        try {
            initMethod.invoke(null, bArray, bOffset, bLength);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(4);
        }
        finally {
            this.registrationCallback.set(null);
        }
        if (callCount.get() != 1) {
            throw new SystemException(4);
        }
    }

    public static class ApplicationInstance {
        private final AID aid;
        private final Applet applet;

        public ApplicationInstance(AID aid, Applet applet) {
            this.aid = aid;
            this.applet = applet;
        }

        public Applet getApplet() {
            return this.applet;
        }

        public String toString() {
            return String.format("ApplicationInstance (%s)", AIDUtil.toString(this.aid));
        }
    }
}

